<?php $__env->startSection('title'); ?>
Board Order <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header_styles'); ?>
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/chosen/css/chosen.css')); ?>"/>
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/daterangepicker/css/daterangepicker.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datepicker/css/bootstrap-datepicker.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/select2/css/select2.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/scroller.bootstrap.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/colReorder.bootstrap.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/dataTables.bootstrap4.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/responsive.bootstrap4.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/pages/dataTables.bootstrap.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/multiselect/css/multi-select.css')); ?>"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/pages/form_elements.css')); ?>"/>

<style>
    table.dt-rowReorder-float {
  position: absolute !important;
  opacity: 0.8;
  table-layout: fixed;
  outline: 2px solid #888;
  outline-offset: -2px;
  z-index: 2001;
}

tr.dt-rowReorder-moving {
  outline: 2px solid #555;
  outline-offset: -2px;
}

body.dt-rowReorder-noOverflow {
  overflow-x: hidden;
}

table.dataTable td.reorder {
  text-align: center;
  cursor: move;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Board Order
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Board Order</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="clearfix"></div>
        
        <div class="card m-t-20">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Board Order</h5>
            </div>
            <div class="card-body">
                
                <input type="hidden" name="_token" id="smToken" value="<?php echo csrf_token(); ?>" />
                
                <div class="table-responsive m-t-20">
                    <div id="info" style="display: none"></div>
                    <button class="btn btn-primary" onclick="update_order()">Save</button>
                    <table class="table table-stripped table-bordered" id="report_table">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Account</th>
                            </tr>
                        </thead>
                        <tbody>
                             <?php $__currentLoopData = $boards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $board): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <tr data-board-id="<?php echo e($board->id); ?>">
                                <td><?php echo e($k); ?>

                                </td>
                                 <td><?php echo e($board->name); ?></td>
                                 <td><?php echo e($board->account->account_name); ?></td>
                             </tr>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <button class="btn btn-primary" onclick="update_order()">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery.uniform/js/jquery.uniform.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputlimiter/js/jquery.inputlimiter.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/chosen/js/chosen.jquery.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pluginjs/jquery.validVal.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/jquery.inputmask.bundle.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/moment/js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/daterangepicker/js/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/datepicker/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/autosize/js/jquery.autosize.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jasny-bootstrap/js/jasny-bootstrap.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jasny-bootstrap/js/inputmask.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/datetimepicker/js/DateTimePicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/j_timepicker/js/jquery.timepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/clockpicker/js/jquery-clockpicker.min.js')); ?>"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="<?php echo e(asset('js/form.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pages/datetime_piker.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/select2/js/select2.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/jquery.dataTables.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/pluginjs/dataTables.tableTools.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.colReorder.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.buttons.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/responsive.bootstrap4.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.rowReorder.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.colVis.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.html5.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.bootstrap.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.print.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.scroller.min.js')); ?>"></script>
<!-- end of plugin scripts -->
<!--Page level scripts-->
<script type="text/javascript" src="<?php echo e(asset('js/pages/simple_datatables.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/multiselect/js/jquery.multi-select.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/pages/form_elements.js')); ?>"></script>

<script type="text/javascript">
    var table =  $('#report_table').DataTable({
            rowReorder: {
                selector: 'tr'
            },
            columnDefs: [
                { targets: 0, visible: false },
                { targets: 1, orderable: false },
                { targets: 2, orderable: false }
            ],
            paging: false,
        });

    function update_order()
    {
        var board_id_arr = [];
        table.rows().every( function ( rowIdx, tableLoop, rowLoop ) {
             var node = table.rows( rowIdx ).nodes()[0];
             var board_id = $(node).attr('data-board-id');
             board_id_arr.push(board_id);
        } );

        //console.log('board_id_arr>>>',board_id_arr);
        var data = {
            boards : board_id_arr,
                };
        data['_token'] = $("input[name=_token]").val();
        $.ajax({
            url: '<?php echo e(route('board_update_order')); ?>',
           // type: "POST",
            method: "POST",
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(data),
            success: function (result) {
                $("#info").html("");
                $("#info").append('<div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>' + result + '</strong></div>');
                $("#info").show();
                var $container = $("html,body");
                var $scrollTo = $('#info');
                $container.animate({scrollTop: $scrollTo.offset().top - $container.offset().top, scrollLeft: 0},300);
                setTimeout(function () {
                    $('#info').fadeOut('fast');
                }, 3000);
                //location.reload();
            },
            error: function (result) {
                var result = JSON.parse(JSON.stringify(result));
                var errorMessage = '';
                if (result.hasOwnProperty('responseJSON') && result.responseJSON.hasOwnProperty('message')) {
                    errorMessage = result.responseJSON.message;
                }

                $("#info").html("");
                $("#info").append('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Fail! </strong>' + errorMessage + '</div>');
                $("#info").show();
                var $container = $("html,body");
                var $scrollTo = $('#info');
                $container.animate({ scrollTop: $scrollTo.offset().top}, 300);
                setTimeout(function () {
                    $('#info').fadeOut('fast');
                }, 3000);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.compact_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncengau/public_html/resources/views/board_order/index.blade.php ENDPATH**/ ?>