<?php $__env->startSection('title'); ?>
Invoice Mapping <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header_styles'); ?>
    <!--Plugin styles-->
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/inputlimiter/css/jquery.inputlimiter.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/chosen/css/chosen.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/jquery-tagsinput/css/jquery.tagsinput.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/daterangepicker/css/daterangepicker.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datepicker/css/bootstrap-datepicker.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/bootstrap-timepicker/css/bootstrap-timepicker.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/bootstrap-switch/css/bootstrap-switch.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/jasny-bootstrap/css/jasny-bootstrap.min.css')); ?>"/>
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/multiselect/css/multi-select.css')); ?>"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/pages/form_elements.css')); ?>"/>
    <!-- end of page level styles -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Invoice Mapping
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('home')); ?>">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('invoice_mapping.index')); ?>">Invoice Mappings</a>
                    </li>
                    <li class="breadcrumb-item active"><?php echo e(__('Create New')); ?> Invoice Mapping</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="clearfix"></div>
        <div class="card m-t-10">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Invoice Mapping</h5>
            </div>
            <div class="card-body p-b-200">
                <?php echo Form::open(['route' => 'invoice_mapping.store','class' =>
            'form-horizontal']); ?>

                    <div class="row">
                        <div class="col-md-12 input_field_sections">
                            <h5>Level</h5>
                            <div class="row">
                                <div class="col-lg-3 m-t-10">
                                    <select class="form-control chzn-select" name="level_select" id="level_select">
                                        <option value="">Select</option>
                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($l->id); ?>"><?php echo e($l->label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-3 m-t-10">
                                    <button type="button" class="btn btn-primary" onclick="display_new()">Add New</button>
                                </div>
                            </div>
                            <div class="row display_new" style="display:none">
                                <div class="col-lg-3">
                                    <input type="text" class="form-control" name="level_new" id="level_new" placeholder="New Level" 
                                       value=""/>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-3 input_field_sections">
                            <h5>Label</h5>
                            <input type="text" required class="form-control" name="label"
                                       value=""/>
                        </div>
                    </div>
                    <div class="row m-t-10">
                        <?php $__currentLoopData = $boards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $board): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" name="boards[]" value="<?php echo e($board->id); ?>">
                        <div class="card col-lg-6 m-t-10">
                            <div class="card-header bg-white">
                                <h5 class="card-title d-inline"><?php echo e($board->name); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="col-lg-12 m-t-10">
                                    <div class="col-lg ">
                                        <h5>Swimlane</h5>
                                        <select multiple class="form-control chzn-select" name="swimlanes[<?php echo e($board->id); ?>][]" tabindex="2">
                                            <option value="">Select</option>
                                            <?php $__currentLoopData = $board->swimlanes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($sl->swimlane_id); ?>"><?php echo e($sl->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12 m-t-10">
                                    <div class="col-lg ">
                                        <h5>Stages</h5>
                                        <select multiple class="form-control chzn-select" name="stages[<?php echo e($board->id); ?>][]" tabindex="2">
                                            <?php $__currentLoopData = $board->tree_stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($s['children'])): ?>
                                            <optgroup label="<?php echo e($s['name']); ?>">
                                                <?php $__currentLoopData = $s['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(isset($fc['children'])): ?>
                                                    <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($fc['name']); ?>">
                                                        <?php $__currentLoopData = $fc['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(isset($sc['children'])): ?>
                                                            <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($sc['name']); ?>">
                                                                <?php $__currentLoopData = $sc['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(isset($tc['children'])): ?>
                                                                <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($tc['name']); ?>">
                                                                </optgroup>
                                                                <?php else: ?>
                                                                <option value="<?php echo e($tc['stage_id']); ?>">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($tc['name']); ?></option>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </optgroup>
                                                            <?php else: ?>
                                                            <option value="<?php echo e($sc['stage_id']); ?>">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($sc['name']); ?></option>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </optgroup>
                                                    <?php else: ?>
                                                    <option value="<?php echo e($fc['stage_id']); ?>">&nbsp;&nbsp;&nbsp;&nbsp;<?php echo e($fc['name']); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                            <?php else: ?>
                                            <option value="<?php echo e($s['stage_id']); ?>"><?php echo e($s['name']); ?></option>
                                            <?php endif; ?>
                                            
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="row m-t-20">
                        <div class="col-lg-3">
                            <input type="submit" class="btn btn-primary" value="save" />
                        </div>
                    </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<!-- plugin level scripts -->
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery.uniform/js/jquery.uniform.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputlimiter/js/jquery.inputlimiter.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/chosen/js/chosen.jquery.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pluginjs/jquery.validVal.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/moment/js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/daterangepicker/js/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/datepicker/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/autosize/js/jquery.autosize.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/inputmask.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/jquery.inputmask.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/inputmask.date.extensions.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/inputmask.extensions.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/multiselect/js/jquery.multi-select.js')); ?>"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.quicksearch/2.3.1/jquery.quicksearch.min.js"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="<?php echo e(asset('js/form.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pages/form_elements.js')); ?>"></script>

    <script type="text/javascript">
        function display_new()
        {
            $("#level_select").val("").trigger("chosen:updated");
            $(".display_new").show();
        }

        $(document).ready(function() {
            $("#level_select").on("change", function(){
                $("#level_new").val("");
                $(".display_new").hide();
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.compact_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncengau/public_html/resources/views/invoice_mapping/create.blade.php ENDPATH**/ ?>