<?php $__env->startSection('title'); ?>
Workload Mapping <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Workload Mapping
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Workload Mapping</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="clearfix"></div>
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Workload Mapping</h5>
                <span class="float-right">
                    <a class="btn btn-primary pull-right"
                        href="<?php echo e(route('workload_mapping.create')); ?>">Add New</a>
                </span>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table" id="kanbanAccounts-table">
                        <thead>
                            <tr>
                                <th>Level</th>
                                <th>Label</th>
                                <th>Fields</th>
                                <th colspan="3">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $WorkloadMappings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(($wm->level) ? $wm->level->label : ""); ?></td>
                                <td><?php echo e($wm->label); ?></td>
                                <td>
                                    <?php $__currentLoopData = $wm->workload_relations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div><b><?php echo e($wr->board->name); ?></b></div>
                                    <div>swimlanes : <?php echo e($wr->swimlane_names); ?></div>
                                    <div>stages : <?php echo e($wr->stage_names); ?></div>
                                    <div>staff : <?php echo e($wr->collab_names); ?></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('workload_mapping.edit', [$wm->id])); ?>" class='btn btn-warning pr-2'><i
                                class="fa fa-edit"></i></a>
                                    <?php echo Form::open(['route' => ['workload_mapping.destroy', $wm->id], 'method' => 'delete']); ?>

                                    <div class='btn-group'>
                                        <?php echo Form::button('<i class="fa fa-trash-o"></i>', ['type' => 'submit', 'class' => 'btn btn-danger', 'onclick' => "return confirm('Are you sure?')"]); ?>

                                    </div>
                                    <?php echo Form::close(); ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.compact_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncengau/public_html/resources/views/workload_mapping/index.blade.php ENDPATH**/ ?>