@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
Workload @parent
@stop

@section('header_styles')
<link type="text/css" rel="stylesheet" href="{{asset('vendors/daterangepicker/css/daterangepicker.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datepicker/css/bootstrap-datepicker.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/select2/css/select2.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/scroller.bootstrap.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/colReorder.bootstrap.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/dataTables.bootstrap4.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/responsive.bootstrap4.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('css/pages/dataTables.bootstrap.css')}}" />
<style type="text/css">
    #report_table td, #report_table th 
    {
        word-break: break-word;
    }
    table.dataTable thead > tr > th {
        padding-left: 5px !important;
        padding-right: 5px !important;
        padding-top: 15px !important ;
    }

    table.dataTable thead .sorting:before,
    table.dataTable thead .sorting_asc:before,
    table.dataTable thead .sorting_desc:before {
        left: auto !important;
        right: 8px !important;
        top: 0px !important;
    }

    table.dataTable thead .sorting:after,
    table.dataTable thead .sorting_asc:after,
    table.dataTable thead .sorting_desc:after {
        left: 8px !important;
        right: auto !important;
        top: 0px !important;
    }
</style>
@stop

@section('content')
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Workload
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Workload</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        @include('flash::message')

        <div class="clearfix"></div>
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Filter</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg input_field_sections">
                        <form>
                            <div class="form-group row form_inline_inputs_bot">
                                <div class="col-lg-3">
                                    <div class="input-group input-group-prepend">
                                        <span class="input-group-text border-right-0 rounded-left rounded_right">
                                                <i class="fa fa-calendar"></i>
                                        </span>
                                        <input type="text" autocomplete="off" class="form-control" value="{{ old('date', $request->date) }}" id="select_date"
                                               name="date">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <select class="form-control chzn-select" name="level_select" id="level_select">
                                        <option value="">Select Level</option>
                                        @foreach($levels as $l)
                                        <option @if($request->level_select == $l->id) selected @endif value="{{$l->id}}">{{$l->label}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-1">
                                    <button class="btn btn-primary layout_btn_prevent btn-responsive form_inline_btn_margin-top">Search</button>
                                </div>
                                <div class="col-lg-1">
                                    <a class="btn btn-secondary" href="{{route('workload.index')}}">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card m-t-20">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Workload</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive m-t-20">
                    <table class="table table-stripped table-bordered" id="report_table">
                        <thead>
                            @if(count($data['vertical_total']) > 0)
                            <tr>
                                <td><b>TOTAL</b></td>
                                @foreach($data['vertical_total'] as $vt)
                                <td class="text-center">
                                    <div>Tasks : {{$vt["task_total"]}}</div>
                                    @if(($vt["time_total"] / 60) > 59)
                                    <div>ET : {{($vt["time_total"] / 60) / 60 }} Hrs</div>
                                    @else
                                    <div>ET :  {{$vt["time_total"] / 60 }} Mins</div>
                                    @endif
                                    @if(($vt["logged_time_total"] / 60) > 59)
                                    <div>LT : {{number_format(($vt["logged_time_total"] / 60) / 60,2) }} Hrs</div>
                                    @else
                                    <div>LT :  {{number_format($vt["logged_time_total"] / 60,2) }} Mins</div>
                                    @endif
                                </td>
                                @endforeach
                                <td class="text-center">
                                    <div>
                                            Tasks : {{array_sum(array_column($data['vertical_total'],'task_total')) }}
                                    </div>
                                    @if(((array_sum(array_column($data['vertical_total'],'time_total'))) / 60) > 59)
                                    <div>
                                            ET : {{number_format((array_sum(array_column($data['vertical_total'],'time_total'))) / 60 /60, 2) }} Hrs
                                    </div>
                                    @else
                                    <div>
                                            ET : {{number_format((array_sum(array_column($data['vertical_total'],'time_total'))) / 60, 2) }} Mins
                                    </div>
                                    @endif

                                    @if(((array_sum(array_column($data['vertical_total'],'logged_time_total'))) / 60) > 59)
                                    <div>
                                            LT : {{number_format((array_sum(array_column($data['vertical_total'],'logged_time_total'))) / 60 /60, 2) }} Hrs
                                    </div>
                                    @else
                                    <div>
                                            LT : {{number_format((array_sum(array_column($data['vertical_total'],'logged_time_total'))) / 60,2) }} Mins
                                    </div>
                                    @endif
                                    
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <th width="5%"></th>
                                @foreach($boards as $board)
                                <th width="5%">{{$board->name}}</th>
                                @endforeach
                                <th width="5%">TOTAL</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data['mapped'] as $data_mapped)
                            <tr>
                                <td class="text-center">{!!$data_mapped[0][0] !!}</td>
                                @php $i = 0; @endphp
                                @foreach($data_mapped[0] as $km => $dm)
                                    @if($km != 0 && $i < count($data_mapped[0]) - 1)
                                        <td>
                                            @if(isset($dm["task"]))
                                            <div>Tasks : {!! $dm["task"] !!}</div>
                                            @endif
                                            @if(isset($dm["time"]))
                                            @if(($dm["time"]/60) > 59)
                                            <div>ET : {!! number_format($dm["time"]/60/60, 2) !!} Hrs</div>
                                            @else
                                            <div>ET : {!! number_format($dm["time"]/60, 2) !!} Mins</div>
                                            @endif
                                            @endif
                                            @if(isset($dm["logged_time"]))
                                            @if(($dm["logged_time"]/60) > 59)
                                            <div>LT : {!! number_format($dm["logged_time"]/60/60, 2) !!} Hrs</div>
                                            @else
                                            <div>LT : {!! number_format($dm["logged_time"]/60, 2) !!} Mins</div>
                                            @endif
                                            @endif
                                        </td>
                                    @endif
                                    @php $i++; @endphp
                                @endforeach 
                                <td class="text-center">
                                    @if(isset($data_mapped[0][array_key_last($data_mapped[0])]["task_total"]))
                                        <div>Tasks : {!! $data_mapped[0][array_key_last($data_mapped[0])]["task_total"] !!} </div>
                                        @if((($data_mapped[0][array_key_last($data_mapped[0])]["time_total"]) / 60) > 59)
                                        <div>ET : {!! number_format(($data_mapped[0][array_key_last($data_mapped[0])]["time_total"]) / 60 / 60, 2) !!} Hrs</div>
                                        @else
                                        <div>ET : {!! number_format(($data_mapped[0][array_key_last($data_mapped[0])]["time_total"]) / 60,2) !!} Mins</div>
                                        @endif

                                        @if((($data_mapped[0][array_key_last($data_mapped[0])]["logged_time_total"]) / 60) > 59)
                                        <div>LT : {!! number_format(($data_mapped[0][array_key_last($data_mapped[0])]["logged_time_total"]) / 60 / 60, 2) !!} Hrs</div>
                                        @else
                                        <div>LT : {!! number_format(($data_mapped[0][array_key_last($data_mapped[0])]["logged_time_total"]) / 60, 2) !!} Mins</div>
                                        @endif
                                    @endif
                                    
                                    
                                </td>
                            </tr>
                            @endforeach
                            @foreach($data['notmapped'] as $data_notmapped)
                            <tr>
                                @foreach($data_notmapped as $records)
                                <td class="text-center">{{$records}}</td>
                                @endforeach
                            </tr>
                            @endforeach
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
    <script type="text/javascript" src="{{asset('vendors/jquery.uniform/js/jquery.uniform.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputlimiter/js/jquery.inputlimiter.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pluginjs/jquery.validVal.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/jquery.inputmask.bundle.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/moment/js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/daterangepicker/js/daterangepicker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/autosize/js/jquery.autosize.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jasny-bootstrap/js/jasny-bootstrap.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jasny-bootstrap/js/inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datetimepicker/js/DateTimePicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/j_timepicker/js/jquery.timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/clockpicker/js/jquery-clockpicker.min.js')}}"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="{{asset('js/form.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pages/datetime_piker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/select2/js/select2.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/jquery.dataTables.js')}}"></script>
<script type="text/javascript" src="{{asset('js/pluginjs/dataTables.tableTools.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.colReorder.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.bootstrap4.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.buttons.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/responsive.bootstrap4.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.rowReorder.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.html5.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.bootstrap.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.print.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.scroller.min.js')}}"></script>
<!-- end of plugin scripts -->
<!--Page level scripts-->
<script type="text/javascript" src="{{asset('js/pages/simple_datatables.js')}}"></script>

<script type="text/javascript">
    $(document).ready(function() {
        $('#report_table').DataTable({
            order: []
        });

        $('#select_date').datepicker({
            format: 'dd-mm-yyyy',
            todayHighlight: true,
            autoclose: true,
            orientation:"bottom"
        });
    })
</script>
@stop
