@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
Swimlane Mapping @parent
@stop

@section('content')
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Swimlane Mapping
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="{{ route('home') }}">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('swimlane_mapping.index') }}">Swimlane Mappings</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Create New') }} Swimlane Mapping</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        @include('flash::message')

        <div class="clearfix"></div>
        <div class="card m-t-10">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Swimlane Field Mapping</h5>
            </div>
            <div class="card-body">
                {!! Form::open(['route' => 'swimlane_mapping.store','class' =>
            'form-horizontal']) !!}
                    <div class="row">
                        <div class="col-lg-3 input_field_sections">
                            <h5>Label</h5>
                            <input type="text" required class="form-control" name="label"
                                       value=""/>
                        </div>
                    </div>
                    <div class="row m-t-10">
                        @foreach($boards as $board)
                        <div class="col-lg-3 m-t-10">
                            <div>{{$board->name}}</div>
                            <div>
                                <select class="form-control chzn-select" name="swimlanes[{{$board->id}}]" tabindex="2">
                                    <option value="">Select</option>
                                    @foreach($board->swimlanes as $sl)
                                    <option value="{{$sl->swimlane_id}}">{{$sl->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="row m-t-20">
                        <div class="col-lg-3">
                            <input type="submit" class="btn btn-primary" value="save" />
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection
