@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
{{ __('Edit') }} Roles @parent
@stop

@section('header_styles')
    <!--Plugin styles-->
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/inputlimiter/css/jquery.inputlimiter.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/chosen/css/chosen.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/jquery-tagsinput/css/jquery.tagsinput.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/daterangepicker/css/daterangepicker.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/datepicker/css/bootstrap-datepicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-switch/css/bootstrap-switch.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/jasny-bootstrap/css/jasny-bootstrap.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/multiselect/css/multi-select.css')}}"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
    <link type="text/css" rel="stylesheet" href="{{asset('css/pages/form_elements.css')}}"/>
    <!-- end of page level styles -->
@stop

@section('content')
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Roles
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="#">Roles</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Edit') }} Roles</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<div class="outer">
    <div class="inner bg-container">
        @include('adminlte-templates::common.errors')
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="text-white">{{ __('Edit') }} Roles</h5>
            </div>
            <div class="card-body mt-3">
                {!! Form::model($roles, ['route' =>
                ['roles.update',
                $roles->id], 'method' => 'patch','class' => 'form-horizontal']) !!}

                @include('roles.fields')

                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<!-- plugin level scripts -->
    <script type="text/javascript" src="{{asset('vendors/jquery.uniform/js/jquery.uniform.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputlimiter/js/jquery.inputlimiter.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/chosen/js/chosen.jquery.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pluginjs/jquery.validVal.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/moment/js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/daterangepicker/js/daterangepicker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/autosize/js/jquery.autosize.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/jquery.inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.date.extensions.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.extensions.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/multiselect/js/jquery.multi-select.js')}}"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.quicksearch/2.3.1/jquery.quicksearch.min.js"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="{{asset('js/form.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pages/form_elements.js')}}"></script>
@stop
