<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="UTF-8">
    <title>
        @section('title')
        | Northern Consulting
        @show
    </title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="{{asset('img/logo1.ico')}}" />
    <!-- global styles-->
    <link type="text/css" rel="stylesheet" href="{{asset('css/components.css')}}" />
    <link type="text/css" rel="stylesheet" href="{{asset('css/custom.css')}}" />
    <link type="text/css" rel="stylesheet" href="#" id="skin_change" />
    <!-- end of global styles-->
    <style>
        .admin_img
        {
            width: 160px;
            height: 70px;
        }
        .sidebar-left-hidden #left .sidebarbottom .menu_hide
        {
            display: inline-block;
        }
    </style>
    @yield('header_styles')
</head>

<body class="sidebar-left-hidden">
    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
        @csrf
    </form>
    <div class="preloader" style=" position: fixed;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  z-index: 100000;
  backface-visibility: hidden;
  background: #ffffff;">
        <div class="preloader_img" style="width: 200px;
  height: 200px;
  position: absolute;
  left: 48%;
  top: 48%;
  background-position: center;
z-index: 999999">
            <img src="{{asset('img/loader.gif')}}" style=" width: 40px;" alt="loading...">
        </div>
    </div>
    <div id="wrap">
        <div id="top">
            <!-- .navbar -->
            <nav class="navbar navbar-static-top">
                <div class="container-fluid m-0">
                    <a class="navbar-brand" href="{{ URL::to('home') }}">
                        <img src="{{asset('img/logo.png')}}" class="admin_img" alt="logo">
                    </a>
                    <div class="menu mr-sm-auto">
                        <span class="toggle-left" id="menu-toggle">
                            <i class="fa fa-bars"></i>
                        </span>
                    </div>
                    <div class="topnav dropdown-menu-right">
                        @if(get_last_data_import_time() != "")
                        <div class="btn-group">
                            <b>Last Data Imported : </b> 
                            {{date('d-m-Y H:i', strtotime(get_last_data_import_time()))}}
                        </div>&nbsp;&nbsp;
                        @endif
                        <div class="btn-group small_device_search" data-toggle="modal" data-target="#search_modal">
                            <i class="fa fa-search text-primary"></i>
                        </div>
                        <div class="btn-group">
                            <div class="notifications request_section no-bg">
                                <a class="btn btn-default btn-sm messages" id="request_btn"> <i class="fa fa-sliders"
                                        aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                        <div class="btn-group">
                            <div class="user-settings no-bg">
                                <button type="button" class="btn btn-default no-bg micheal_btn" data-toggle="dropdown">
                                    
                                    <strong>{{Auth::user()->name}}</strong>
                                    <span class="fa fa-sort-down white_bg"></span>
                                </button>
                                <div class="dropdown-menu admire_admin">
                                    <a class="dropdown-item title" href="#">
                                        Admin</a>
                                    <!-- <a class="dropdown-item" href="edit_user"><i class="fa fa-cogs"></i>
                                        Account Settings</a> -->
                                    <a class="dropdown-item" href="{{route('logout')}}" onclick="event.preventDefault();document.getElementById('logout-form').submit();"><i class="fa fa-sign-out"></i>
                                        Log Out</a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- /.container-fluid -->
            </nav>
            <!-- /.navbar -->
            <!-- /.head -->
        </div>
        <!-- /#top -->
        <div class="wrapper">
            <div id="left">
                <div class="menu_scroll">
                    <div class="left_media">
                        <div class="media user-media">
                            <div class="user-media-toggleHover">
                                <span class="fa fa-user"></span>
                            </div>
                            <div class="user-wrapper">
                                <a class="user-link" href="#">
                                    <!-- <img class="media-object img-thumbnail user-img rounded-circle admin_img3"
                                        alt="User Picture" src="{{asset('img/admin.jpg')}}"> -->
                                    @php
                                    $words = explode(" ", Auth::user()->name);
                                    $initials = null;
                                    foreach ($words as $w) {
                                         $initials .= $w[0];
                                    }
                                    @endphp
                                    <p class="media-object img-thumbnail user-img rounded-circle admin_img3" style="display: table; text-align: center;">
                                        <span style="color: black;display: table-cell;vertical-align: middle;">{{$initials}}</span></p>
                                    <p class="user-info menu_hide">Welcome {{Auth::user()->name}}</p>
                                </a>
                            </div>
                        </div>
                        <hr />
                    </div>
                    <ul id="menu">
                        <li {!! (Request::is('home')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('home') }} ">
                                <i class="fa fa-home"></i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Dashboard</span>
                            </a>
                        </li>
                        <!-- <li {!! (Request::is('swimlane_report')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('swimlane_report') }} ">
                                <i class="fa fa-magic"></i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Swimlane Report</span>
                            </a>
                        </li> -->
                        <li {!! (Request::is('global_snapshot')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('global_snapshot') }} ">
                                <i class="fa">GS</i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Global Snapshot</span>
                            </a>
                        </li>

                        <li {!! (Request::is('workload')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('workload') }} ">
                                <i class="fa">WL</i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Workload</span>
                            </a>
                        </li>

                        <li {!! (Request::is('invoice')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('invoice') }} ">
                                <i class="fa">IR</i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Invoice</span>
                            </a>
                        </li>

                        <li {!! (Request::is('exception')? 'class="active"' :"") !!}>
                            <a href="{{ URL::to('exception') }} ">
                                <i class="fa">ER</i>
                                <span class="link-title menu_hide">&nbsp;&nbsp;Exception</span>
                            </a>
                        </li>
                        
                        <li class="dropdown_menu {!!  (Request::is('swimlane_mapping') || Request::is('global_ss_mapping') || 
                        Request::is('workload_mapping') || 
                        Request::is('invoice_mapping') ||
                        Request::is('exception_mapping') || 
                        Request::is('board_order') || 
                        Request::is('kanbanAccounts*') || Request::is('builder')? 'active':'')!!}">
                            <a href="#">
                                <i class="fa fa-gear"></i>
                                <span class="link-title menu_hide">&nbsp; Settings</span>
                                <span class="fa arrow menu_hide"></span>
                            </a>
                            <ul>
                                <!-- <li {!! (Request::is('swimlane_mapping')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('swimlane_mapping') }} ">
                                        <i class="fa fa-file-code-o"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Swimlane Mapping</span>
                                    </a>
                                </li> -->
                                <li {!! (Request::is('global_ss_mapping')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('global_ss_mapping') }} ">
                                        <i class="fa fa-file-code-o"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Global Snapshot Mapping</span>
                                    </a>
                                </li>
                                <li {!! (Request::is('workload_mapping')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('workload_mapping') }} ">
                                        <i class="fa fa-file-code-o"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Workload Mapping</span>
                                    </a>
                                </li>
                                <li {!! (Request::is('invoice_mapping')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('invoice_mapping') }} ">
                                        <i class="fa fa-file-code-o"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Invoice Mapping</span>
                                    </a>
                                </li>
                                <li {!! (Request::is('exception_mapping')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('exception_mapping') }} ">
                                        <i class="fa fa-file-code-o"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Exception Mapping</span>
                                    </a>
                                </li>

                                <li {!! (Request::is('board_order')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('board_order') }} ">
                                        <i class="fa fa-sort"></i>
                                        <span class="link-title menu_hide">&nbsp;&nbsp;Board Order</span>
                                    </a>
                                </li>
                                @include('layouts.menu')
                                <!-- <li {!! (Request::is('builder')? 'class="active"' :"") !!}>
                                    <a href="{{ URL::to('builder') }} ">
                                        <i class="fa fa-magic"></i>
                                        <span class="link-title menu_hide">&nbsp;Crud Builder
                                        </span>
                                    </a>
                                </li> -->
                            </ul>
                        </li>
                    </ul>
                    <!-- /#menu -->
                </div>
            </div>
            <!-- /#left -->

            <div id="content" class="bg-container">
                <!-- Content -->
                @yield('content')
                <!-- Content end -->
            </div>
            <div class="modal fade" id="search_modal" tabindex="-1" role="dialog" aria-hidden="true">
                <form>
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span class="float-right" aria-hidden="true">&times;</span>
                            </button>
                            <div class="input-group search_bar_small">
                                <input type="text" class="form-control" placeholder="Search..." name="search">
                                <span class="input-group-append">
                                    <button class="btn btn-secondary" type="submit"><i
                                            class="fa fa-search"></i></button>
                                </span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- /#content -->
        @include('layouts/right_sidebar/default')

    </div>
    <!-- /#wrap -->
    <!-- global scripts-->
    <script type="text/javascript" src="{{asset('js/components.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/custom.js')}}"></script>
    <!-- end of global scripts-->
    <!-- page level js -->
    @yield('footer_scripts')
    <!-- end page level js -->
</body>

</html>
