@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
Exception @parent
@stop

@section('header_styles')
<link type="text/css" rel="stylesheet" href="{{asset('vendors/chosen/css/chosen.css')}}"/>
<link type="text/css" rel="stylesheet" href="{{asset('vendors/daterangepicker/css/daterangepicker.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datepicker/css/bootstrap-datepicker.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/select2/css/select2.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/scroller.bootstrap.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/colReorder.bootstrap.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/dataTables.bootstrap4.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/datatables/css/responsive.bootstrap4.min.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('css/pages/dataTables.bootstrap.css')}}" />
<link type="text/css" rel="stylesheet" href="{{asset('vendors/multiselect/css/multi-select.css')}}"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
<link type="text/css" rel="stylesheet" href="{{asset('css/pages/form_elements.css')}}"/>
@stop

@section('content')
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Exception
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Exception</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        @include('flash::message')

        <div class="clearfix"></div>
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Filter</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg input_field_sections">
                        <form id="report_search_form">
                            <div class="form-group row form_inline_inputs_bot">
                                <div class="col-lg-3">
                                    <div class="input-group input-group-prepend">
                                        <span class="input-group-text border-right-0 rounded-left rounded_right">
                                                <i class="fa fa-calendar"></i>
                                        </span>
                                        <input type="text" autocomplete="off" class="form-control" value="{{ old('date', $request->date) }}" id="select_date"
                                               name="date">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <select class="form-control chzn-select" name="board" id="board" tabindex="2">
                                        @foreach($boards as $b)
                                        <option {{($b->id == $request->board) ? "selected" : ""}} value="{{$b->id}}">{{$b->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-3">
                                    <select class="form-control chzn-select" name="level_select" id="level_select">
                                        <option value="">Select Level</option>
                                        @foreach($levels as $l)
                                        <option @if($request->level_select == $l->id) selected @endif value="{{$l->id}}">{{$l->label}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-1">
                                    <button class="btn btn-primary layout_btn_prevent btn-responsive form_inline_btn_margin-top">Search</button>
                                </div>
                                <div class="col-lg-1">
                                    <a class="btn btn-secondary" href="{{route('exception.index')}}">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card m-t-20">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Exception : <b>{{$request->date}}</b></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive m-t-20">
                    @if(isset($data['head']))
                    <table class="table table-stripped table-bordered" id="report_table">
                        <thead>
                            <tr>
                                @foreach(json_decode($data['head']->data) as $h)
                                <th>{{$h}}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data['body'] as $b)
                                <tr>
                                    @php $kd = 0; @endphp
                                    @foreach(json_decode($b->data) as $d)
                                    <td class="{{($kd == 0) ? '' : 'text-center'}}">{!! html_entity_decode($d) !!}</td>
                                    @php $kd++; @endphp
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <div>Data is not available.</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
    <script type="text/javascript" src="{{asset('vendors/jquery.uniform/js/jquery.uniform.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputlimiter/js/jquery.inputlimiter.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/chosen/js/chosen.jquery.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pluginjs/jquery.validVal.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/jquery.inputmask.bundle.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/moment/js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/daterangepicker/js/daterangepicker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/autosize/js/jquery.autosize.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jasny-bootstrap/js/jasny-bootstrap.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jasny-bootstrap/js/inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datetimepicker/js/DateTimePicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/j_timepicker/js/jquery.timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/clockpicker/js/jquery-clockpicker.min.js')}}"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="{{asset('js/form.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pages/datetime_piker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/select2/js/select2.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/jquery.dataTables.js')}}"></script>
<script type="text/javascript" src="{{asset('js/pluginjs/dataTables.tableTools.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.colReorder.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.bootstrap4.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.buttons.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/responsive.bootstrap4.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.rowReorder.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.html5.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.bootstrap.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/buttons.print.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/datatables/js/dataTables.scroller.min.js')}}"></script>
<!-- end of plugin scripts -->
<!--Page level scripts-->
<script type="text/javascript" src="{{asset('js/pages/simple_datatables.js')}}"></script>
<script type="text/javascript" src="{{asset('vendors/multiselect/js/jquery.multi-select.js')}}"></script>
<script type="text/javascript" src="{{asset('js/pages/form_elements.js')}}"></script>

<script type="text/javascript">
    $(document).ready(function() {

        $('#report_table').DataTable({
            order: [[3, 'desc']]
        });

        $('#select_date').datepicker({
            format: 'dd-mm-yyyy',
            todayHighlight: true,
            autoclose: true,
            orientation:"bottom"
        });
        
    })
</script>
@stop