<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('workload_mappings', function (Blueprint $table) {
            $table->unsignedBigInteger('level_id')->after('id')->nullable();

             $table->foreign('level_id')->references('id')->on('workload_mapping_levels')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('workload_mappings', function (Blueprint $table) {
            $table->dropColumn('level_id');
        });
    }
};
