<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_mapping_relations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_mapping_id');
            $table->unsignedBigInteger('board_id');
            $table->longText('swimlane_ids')->nullable();
            $table->longText('stage_ids')->nullable();

            $table->foreign('invoice_mapping_id')->references('id')->on('invoice_mappings')->onUpdate('cascade')->onDelete('cascade');

            $table->foreign('board_id')->references('id')->on('boards')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_mapping_relations');
    }
};
