<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('global_snapshot_mapping_relations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('global_ss_mapping_id');
            $table->unsignedBigInteger('board_id');
            $table->longText('swimlane_ids')->nullable();
            $table->longText('stage_ids')->nullable();

            $table->foreign('global_ss_mapping_id')->references('id')->on('global_snapshot_mappings')->onUpdate('cascade')->onDelete('cascade');

            $table->foreign('board_id')->references('id')->on('boards')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('global_snapshot_mapping_relations');
    }
};
