<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('board_workflow_stages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('board_id');
            $table->unsignedInteger('stage_id');
            $table->unsignedInteger('kb_board_id');
            $table->string('name')->nullable();
            $table->string('full_name')->nullable();
            $table->unsignedInteger('wip_limit')->nullable();
            $table->string('wip_limit_type')->nullable();
            $table->unsignedInteger('position')->nullable();
            $table->unsignedInteger('lane_width')->nullable();
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('lft')->nullable();
            $table->unsignedInteger('rgt')->nullable();
            $table->unsignedInteger('board_version')->nullable();
            $table->text('description')->nullable();
            $table->unsignedInteger('lane_type_id')->nullable();
            $table->unsignedInteger('archive_enabled')->nullable();
            $table->string('lane_type')->nullable();

            
            $table->timestamps();

            $table->unique(['board_id', 'stage_id']);

            $table->foreign('board_id')->references('id')->on('boards')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('board_workflow_stages');
    }
};
