<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class BoardCollaborators
 * @package App\Models
 * @version July 21, 2022, 12:15 pm UTC
 *
 */
class WorkloadMappings extends Model
{

    public $table = 'workload_mappings';

    public $fillable = ["label", "level_id"];

    public function workload_relations()
    {
        return $this->hasMany(WorkloadRelations::class, 'workload_mapping_id', 'id');
    }

    public function level()
    {
        return $this->hasOne(WorkloadMappingLevels::class, 'id', 'level_id');
    }

}