<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class BoardCollaborators
 * @package App\Models
 * @version July 21, 2022, 12:15 pm UTC
 *
 */
class GlobalSSMappings extends Model
{

    public $table = 'global_snapshot_mappings';

    public $fillable = ["label", "level_id"];

    public function global_ss_relations()
    {
        return $this->hasMany(GlobalSSRelations::class, 'global_ss_mapping_id', 'id');
    }

    public function level()
    {
        return $this->hasOne(GlobalSSMappingLevels::class, 'id', 'level_id');
    }

}