<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class ExceptionMappings
 * @package App\Models
 * @version July 21, 2022, 12:15 pm UTC
 *
 */
class ExceptionMappings extends Model
{

    public $table = 'exception_mappings';

    public $fillable = ["label", "level_id"];

    public function exception_relations()
    {
        return $this->hasMany(ExceptionRelations::class, 'exception_mapping_id', 'id');
    }

    public function level()
    {
        return $this->hasOne(ExceptionMappingLevels::class, 'id', 'level_id');
    }

}