<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class Boards
 * @package App\Models
 * @version July 21, 2022, 12:15 pm UTC
 *
 * @property int $kanban_account_id
 * @property int $board_id
 * @property string $name
 * @property int $position
 * @property date $last_activity_on
 * @property text $permissions
 */
class Boards extends Model
{

    public $table = 'boards';
    public $fillable = [
        'kanban_account_id',
        'board_id',
        'name',
        'position',
        'last_activity_on',
        'permissions'
    ];

    public function swimlanes()
    {
        return $this->hasMany(BoardSwimlanes::class, 'board_id', 'id');
    }

    public function stages()
    {
        return $this->hasMany(BoardStages::class, 'board_id', 'id');
    }

    public function collabs()
    {
        return $this->hasMany(BoardCollaborators::class, 'board_id', 'id')->where("active",1);
    }

    public function account()
    {
        return $this->hasOne(KanbanAccounts::class, 'id', 'kanban_account_id');
    }
}