<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;

use App\Models\KanbanAccounts;
use App\Models\BoardSwimlanes;
use App\Models\Boards;
use App\Models\BoardTasks;
use App\Models\SwimlaneMappings;
use App\Models\SwimlaneMappingRelations;

use Illuminate\Http\Request;
use Flash;
use Response;
use Carbon\Carbon;

class SwimlaneReportController extends AppBaseController
{
    /**
     * Display a listing of the Swimline Report.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $data = [];

        $boards = Boards::get();
        $mappings = SwimlaneMappings::get();

        $mapped_swimlanes = [];

        foreach($mappings as $key_map => $mapping)
        {
            $mapped_swimlanes_inner = [];
            $horizontal_total = 0;
            foreach($mapping->swimlane_relations as $sr)
            {
                $mapped_swimlanes[] = $sr->swimlane_id;
                $mapped_swimlanes_inner[] = $sr->swimlane_id;
                
            }

            foreach($boards as $b)
            {
                $data['mapped'][$key_map][0]=$mapping->label;
                $qry = BoardTasks::where('board_id',$b->id)->whereIn('kb_swimlane_id', $mapped_swimlanes_inner);

                if($request->daterange && $request->daterange!="")
                {
                    $dates = explode(" - ", $request->daterange);
                    $from = $dates[0]." 00:00:00";
                    $to = $dates[1]." 23:59:59";
                    $startDate = Carbon::createFromFormat('m/d/Y H:i:s', $from);
                    $endDate = Carbon::createFromFormat('m/d/Y H:i:s', $to);

                    $qry->whereBetween('kb_created_at', [$startDate, $endDate]);
                }

                $task_count = $qry->count();
                $data['mapped'][$key_map][$b->id] = $task_count;
                $horizontal_total = $horizontal_total+$task_count;
            }
            $data['mapped'][$key_map][]=$horizontal_total;
        }

        $swimlanes = BoardSwimlanes::whereNotIn('swimlane_id', $mapped_swimlanes)->get();

        foreach($swimlanes as $key => $sl)
        {
            $horizontal_total = 0;
            foreach($boards as $b)
            {
                $data['notmapped'][$key][0]=$sl->name;
                $qry = BoardTasks::where('board_id',$b->id)->where('kb_swimlane_id', $sl->swimlane_id);

                if($request->daterange && $request->daterange!="")
                {
                    $dates = explode(" - ", $request->daterange);
                    $from = $dates[0]." 00:00:00";
                    $to = $dates[1]." 23:59:59";
                    $startDate = Carbon::createFromFormat('m/d/Y H:i:s', $from);
                    $endDate = Carbon::createFromFormat('m/d/Y H:i:s', $to);

                    $qry->whereBetween('kb_created_at', [$startDate, $endDate]);
                }
                $task_count = $qry->count();

                $data['notmapped'][$key][$b->id] = $task_count;
                $horizontal_total = $horizontal_total+$task_count;
            } 
            $data['notmapped'][$key][]=$horizontal_total;
        }


        return view('swimlane_reports.index')
            ->with('boards', $boards)->with('data', $data)->with('request',$request);

    }
}