<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;

use App\Models\KanbanAccounts;
use App\Models\BoardSwimlanes;
use App\Models\Boards;
use App\Models\SwimlaneMappings;
use App\Models\SwimlaneMappingRelations;

use Illuminate\Http\Request;
use Flash;
use Response;

class SwimlaneMappingController extends AppBaseController
{
    /**
     * Display a listing of the Swimline Mapping.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $SwimlaneMappings = SwimlaneMappings::get();

        return view('swimlane_mapping.index')
            ->with('SwimlaneMappings', $SwimlaneMappings);

    }

    /**
     * Show the form for creating a new KanbanAccounts.
     *
     * @return Response
     */
    public function create()
    {
        $boards = Boards::get();

        return view('swimlane_mapping.create')->with('boards', $boards);
    }

    public function store(Request $request)
    {
        $s_map = SwimlaneMappings::create(["label" => $request->label]);

        $s_map_relations = [];
        foreach($request->swimlanes as $board_id => $swimlane_id)
        {
            if($swimlane_id != "")
            {
                $s_map_relations_single = [];
                $s_map_relations_single['swimlane_mapping_id'] = $s_map->id;
                $s_map_relations_single['board_id'] = $board_id;
                $s_map_relations_single['swimlane_id'] = $swimlane_id;

                array_push($s_map_relations, $s_map_relations_single);
            }
            
        }

        if(count($s_map_relations) > 0)
        {
            SwimlaneMappingRelations::insert($s_map_relations);
        }

        return redirect(route('swimlane_mapping.index'));

    }

    public function destroy($id)
    {
        /** @var SwimlaneMappings $SwimlaneMappings */
        $SwimlaneMappings = SwimlaneMappings::find($id);

        if (empty($SwimlaneMappings)) {
            Flash::error('Mapping not found');

            return redirect(route('swimlane_mapping.index'));
        }

        $SwimlaneMappings->delete();

        Flash::success('Mapping deleted successfully.');

        return redirect(route('swimlane_mapping.index'));
    }
}