<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateRolesRequest;
use App\Http\Requests\UpdateRolesRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Roles;
use App\Models\GlobalSSMappingLevels;
use App\Models\WorkloadMappingLevels;
use App\Models\InvoiceMappingLevels;
use App\Models\ExceptionMappingLevels;
use App\Models\RoleLevels;

use Illuminate\Http\Request;
use Flash;
use Response;

class RolesController extends AppBaseController
{
    /**
     * Display a listing of the Roles.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Roles $roles */
        $roles = Roles::paginate(10);

        return view('roles.index')
            ->with('roles', $roles);
    }

    /**
     * Show the form for creating a new Roles.
     *
     * @return Response
     */
    public function create()
    {
        $global_levels = GlobalSSMappingLevels::pluck('label','id');
        $workload_levels = WorkloadMappingLevels::pluck('label','id');
        $invoice_levels = InvoiceMappingLevels::pluck('label','id');
        $exception_levels = ExceptionMappingLevels::pluck('label','id');

        return view('roles.create')->with('global_levels', $global_levels)->with('workload_levels', $workload_levels)->with('invoice_levels', $invoice_levels)->with('exception_levels', $exception_levels);
    }

    /**
     * Store a newly created Roles in storage.
     *
     * @param CreateRolesRequest $request
     *
     * @return Response
     */
    public function store(CreateRolesRequest $request)
    {
        $input = $request->all();

        /** @var Roles $roles */
        $roles = Roles::create($input);

        if(isset($request->global_levels))
        {
            $g_data = [];

            foreach($request->global_levels as $gl)
            {
                $g_data_s["role_id"] = $roles->id;
                $g_data_s["type"] = "global";
                $g_data_s["level_id"] = $gl;

                array_push($g_data, $g_data_s);
            }

            if(count($g_data) > 0)
            {
               RoleLevels::insert($g_data); 
            }
        }

        if(isset($request->workload_levels))
        {
            $w_data = [];

            foreach($request->workload_levels as $wl)
            {
                $w_data_s["role_id"] = $roles->id;
                $w_data_s["type"] = "workload";
                $w_data_s["level_id"] = $wl;

                array_push($w_data, $w_data_s);
            }

            if(count($w_data) > 0)
            {
               RoleLevels::insert($w_data); 
            }
        }

        if(isset($request->invoice_levels))
        {
            $i_data = [];

            foreach($request->invoice_levels as $il)
            {
                $i_data_s["role_id"] = $roles->id;
                $i_data_s["type"] = "invoice";
                $i_data_s["level_id"] = $il;

                array_push($i_data, $i_data_s);
            }

            if(count($i_data) > 0)
            {
               RoleLevels::insert($i_data); 
            }
        }
        if(isset($request->exception_levels))
        {
            $e_data = [];

            foreach($request->exception_levels as $el)
            {
                $e_data_s["role_id"] = $roles->id;
                $e_data_s["type"] = "exception";
                $e_data_s["level_id"] = $el;

                array_push($e_data, $e_data_s);
            }

            if(count($e_data) > 0)
            {
               RoleLevels::insert($e_data); 
            }
        }

        Flash::success('Roles saved successfully.');

        return redirect(route('roles.index'));
    }

    /**
     * Display the specified Roles.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Roles $roles */
        $roles = Roles::find($id);

        if (empty($roles)) {
            Flash::error('Roles not found');

            return redirect(route('roles.index'));
        }

        return view('roles.show')->with('roles', $roles);
    }

    /**
     * Show the form for editing the specified Roles.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Roles $roles */
        $roles = Roles::find($id);
        
        $global_levels = GlobalSSMappingLevels::pluck('label','id');
        $workload_levels = WorkloadMappingLevels::pluck('label','id');
        $invoice_levels = InvoiceMappingLevels::pluck('label','id');
        $exception_levels = ExceptionMappingLevels::pluck('label','id');

        if (empty($roles)) {
            Flash::error('Roles not found');

            return redirect(route('roles.index'));
        }

        $selected_g_l = RoleLevels::where('role_id', $id)->where('type', 'global')->pluck('level_id');
        $selected_w_l = RoleLevels::where('role_id', $id)->where('type', 'workload')->pluck('level_id');
        $selected_i_l = RoleLevels::where('role_id', $id)->where('type', 'invoice')->pluck('level_id');
        $selected_e_l = RoleLevels::where('role_id', $id)->where('type', 'exception')->pluck('level_id');

        return view('roles.edit')->with('roles', $roles)->with('global_levels', $global_levels)->with('workload_levels', $workload_levels)->with('invoice_levels', $invoice_levels)->with('exception_levels', $exception_levels)->with('selected_g_l', $selected_g_l)->with('selected_w_l', $selected_w_l)->with('selected_i_l', $selected_i_l)->with('selected_e_l', $selected_e_l);
    }

    /**
     * Update the specified Roles in storage.
     *
     * @param int $id
     * @param UpdateRolesRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateRolesRequest $request)
    {
        /** @var Roles $roles */
        $roles = Roles::find($id);

        if (empty($roles)) {
            Flash::error('Roles not found');

            return redirect(route('roles.index'));
        }

        $roles->fill($request->all());
        $roles->save();

        RoleLevels::where('role_id',$id)->delete();

        if(isset($request->global_levels))
        {
            $g_data = [];

            foreach($request->global_levels as $gl)
            {
                $g_data_s["role_id"] = $id;
                $g_data_s["type"] = "global";
                $g_data_s["level_id"] = $gl;

                array_push($g_data, $g_data_s);
            }

            if(count($g_data) > 0)
            {
               RoleLevels::insert($g_data); 
            }
        }

        if(isset($request->workload_levels))
        {
            $w_data = [];

            foreach($request->workload_levels as $wl)
            {
                $w_data_s["role_id"] = $id;
                $w_data_s["type"] = "workload";
                $w_data_s["level_id"] = $wl;

                array_push($w_data, $w_data_s);
            }

            if(count($w_data) > 0)
            {
               RoleLevels::insert($w_data); 
            }
        }

        if(isset($request->invoice_levels))
        {
            $i_data = [];

            foreach($request->invoice_levels as $il)
            {
                $i_data_s["role_id"] = $id;
                $i_data_s["type"] = "invoice";
                $i_data_s["level_id"] = $il;

                array_push($i_data, $i_data_s);
            }

            if(count($i_data) > 0)
            {
               RoleLevels::insert($i_data); 
            }
        }
        if(isset($request->exception_levels))
        {
            $e_data = [];

            foreach($request->exception_levels as $el)
            {
                $e_data_s["role_id"] = $id;
                $e_data_s["type"] = "exception";
                $e_data_s["level_id"] = $el;

                array_push($e_data, $e_data_s);
            }

            if(count($e_data) > 0)
            {
               RoleLevels::insert($e_data); 
            }
        }

        Flash::success('Roles updated successfully.');

        return redirect(route('roles.index'));
    }

    /**
     * Remove the specified Roles from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Roles $roles */
        $roles = Roles::find($id);

        if (empty($roles)) {
            Flash::error('Roles not found');

            return redirect(route('roles.index'));
        }

        $roles->delete();

        Flash::success('Roles deleted successfully.');

        return redirect(route('roles.index'));
    }
}
