<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateKanbanAccountsRequest;
use App\Http\Requests\UpdateKanbanAccountsRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\KanbanAccounts;
use Illuminate\Http\Request;
use Flash;
use Response;

class KanbanAccountsController extends AppBaseController
{
    /**
     * Display a listing of the KanbanAccounts.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::paginate(10);

        return view('kanban_accounts.index')
            ->with('kanbanAccounts', $kanbanAccounts);
    }

    /**
     * Show the form for creating a new KanbanAccounts.
     *
     * @return Response
     */
    public function create()
    {
        return view('kanban_accounts.create');
    }

    /**
     * Store a newly created KanbanAccounts in storage.
     *
     * @param CreateKanbanAccountsRequest $request
     *
     * @return Response
     */
    public function store(CreateKanbanAccountsRequest $request)
    {
        $input = $request->all();

        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::create($input);

        Flash::success('Kanban Accounts saved successfully.');

        return redirect(route('kanbanAccounts.index'));
    }

    /**
     * Display the specified KanbanAccounts.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::find($id);

        if (empty($kanbanAccounts)) {
            Flash::error('Kanban Accounts not found');

            return redirect(route('kanbanAccounts.index'));
        }

        return view('kanban_accounts.show')->with('kanbanAccounts', $kanbanAccounts);
    }

    /**
     * Show the form for editing the specified KanbanAccounts.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::find($id);

        if (empty($kanbanAccounts)) {
            Flash::error('Kanban Accounts not found');

            return redirect(route('kanbanAccounts.index'));
        }

        return view('kanban_accounts.edit')->with('kanbanAccounts', $kanbanAccounts);
    }

    /**
     * Update the specified KanbanAccounts in storage.
     *
     * @param int $id
     * @param UpdateKanbanAccountsRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateKanbanAccountsRequest $request)
    {
        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::find($id);

        if (empty($kanbanAccounts)) {
            Flash::error('Kanban Accounts not found');

            return redirect(route('kanbanAccounts.index'));
        }

        $kanbanAccounts->fill($request->all());
        $kanbanAccounts->save();

        Flash::success('Kanban Accounts updated successfully.');

        return redirect(route('kanbanAccounts.index'));
    }

    /**
     * Remove the specified KanbanAccounts from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var KanbanAccounts $kanbanAccounts */
        $kanbanAccounts = KanbanAccounts::find($id);

        if (empty($kanbanAccounts)) {
            Flash::error('Kanban Accounts not found');

            return redirect(route('kanbanAccounts.index'));
        }

        $kanbanAccounts->delete();

        Flash::success('Kanban Accounts deleted successfully.');

        return redirect(route('kanbanAccounts.index'));
    }
}
