<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Http;

use App\Models\KanbanAccounts;
use App\Models\Boards;
use App\Models\BoardStages;
use App\Models\BoardCollaborators;
use App\Models\BoardSwimlanes;
use App\Models\BoardTasks;
use App\Models\TaskTimers;
use App\Models\LastImportedTiming;
use App\Models\GlobalSSMappingLevels;
use App\Models\GlobalSSMappings;
use App\Models\RoleLevels;
use App\Models\WorkloadMappingLevels;
use App\Models\WorkloadMappings;
use App\Models\ExceptionMappingLevels;
use App\Models\ExceptionMappings;


use App\Http\Controllers\GlobalSnapshotController;
use App\Http\Controllers\WorkloadController;
use App\Http\Controllers\ExceptionController;


use View;
use Artisan;
use Str;
use Auth;

use DataTables;

class HomeController extends Controller
{
	public function index()
    {
        // $last_imported_time = LastImportedTiming::first();

        // //$KanbanAccounts = KanbanAccounts::get();

        // $KanbanAccounts = KanbanAccounts::where('account_name', '!=', "test-teqpier")->get();

        // foreach($KanbanAccounts as $ka)
        // {
        //     $response = Http::withHeaders([
        //                 'Authorization' => 'Bearer '.$ka->token
        //             ])->get('https://'.$ka->url.'/api/v3/users/current.json');

        //     $result = $response->getBody()->getContents();

        //     $details = json_decode($result);

        //     foreach($details->boards as $board)
        //     {
        //         $b_inserted = Boards::updateOrCreate([
        //                     'kanban_account_id' => $ka->id,
        //                     'board_id'   => $board->id,
        //                 ],[
        //                     'kanban_account_id' => $ka->id,
        //                     'board_id' => $board->id,
        //                     'name' => $board->name,
        //                     'position' => $board->position,
        //                     'last_activity_on' => $board->last_activity_on,
        //                     'permissions' => json_encode($board->permissions),
        //                 ]);

        //         $response_board_details = Http::timeout(300)->withHeaders([
        //                 'Authorization' => 'Bearer '.$ka->token
        //             ])->get('https://'.$ka->url.'/api/v3/boards/'.$board->id.'.json');
        
        //         $result_board = $response_board_details->getBody()->getContents();

        //         $board_detail = json_decode($result_board);


        //         $settings = $board_detail->settings->card_template;
        //         $settings = json_decode(json_encode($settings) , true);
        //         $invoice_field = "";

        //         foreach($settings as $ks => $bs)
        //         {
        //             if (array_key_exists("label",$bs))
        //             {
        //                 if($bs['label'] == "Invoice value") 
        //                 {
        //                     $invoice_field = $ks;
        //                 }
        //             }
        //         }

        //         // // swimlanes
        //         // $swimlanes = [];

        //         // foreach($board_detail->swimlanes as $swimlane)
        //         // {
        //         //    $single_swimlane = [];
        //         //    $single_swimlane['board_id'] = $b_inserted->id;
        //         //    $single_swimlane['swimlane_id'] = $swimlane->id;
        //         //    $single_swimlane['name'] = $swimlane->name;
        //         //    $single_swimlane['limit'] = $swimlane->limit;
        //         //    $single_swimlane['position'] = $swimlane->position;
        //         //    $single_swimlane['description'] = $swimlane->description;

        //         //    array_push($swimlanes, $single_swimlane);
        //         // }

        //         // if(count($swimlanes) > 0)
        //         // {
        //         //     BoardSwimlanes::upsert($swimlanes,["board_id", "swimlane_id"]);
        //         // }

        //         // // collaborators
        //         // $collaborators = [];

        //         // foreach($board_detail->collaborators as $collaborator)
        //         // {
        //         //    $single_collaborator = [];
        //         //    $single_collaborator['board_id'] = $b_inserted->id;
        //         //    $single_collaborator['collaborator_id'] = $collaborator->id;
        //         //    $single_collaborator['name'] = $collaborator->name;
        //         //    $single_collaborator['initials'] = $collaborator->initials;
        //         //    $single_collaborator['active'] = $collaborator->active;

        //         //    array_push($collaborators, $single_collaborator);
        //         // }

        //         // if(count($collaborators) > 0)
        //         // {
        //         //     BoardCollaborators::upsert($collaborators,["board_id", "collaborator_id"]);
        //         // }

        //         // //workflow stages
        //         // $stages = [];
        //         // foreach($board_detail->workflow_stages as $stage)
        //         // {
        //         //     $single_stage = [];
        //         //     $single_stage['board_id'] = $b_inserted->id;
        //         //     $single_stage['stage_id'] = $stage->id;
        //         //     $single_stage['kb_board_id'] = $stage->board_id;
        //         //     $single_stage['name'] = $stage->name;
        //         //     $single_stage['full_name'] = $stage->full_name;
        //         //     $single_stage['wip_limit'] = $stage->wip_limit;
        //         //     $single_stage['wip_limit_type'] = $stage->wip_limit_type;
        //         //     $single_stage['position'] = $stage->position;
        //         //     $single_stage['lane_width'] = $stage->lane_width;
        //         //     $single_stage['parent_id'] = $stage->parent_id;
        //         //     $single_stage['lft'] = $stage->lft;
        //         //     $single_stage['rgt'] = $stage->rgt;
        //         //     $single_stage['board_version'] = $stage->board_version;
        //         //     $single_stage['description'] = $stage->description;
        //         //     $single_stage['lane_type_id'] = $stage->lane_type_id;
        //         //     $single_stage['archive_enabled'] = $stage->archive_enabled;
        //         //     $single_stage['lane_type'] = $stage->lane_type;

        //         //     array_push($stages, $single_stage);
        //         // }

        //         // if(count($stages) > 0)
        //         // {
        //         //     BoardStages::upsert($stages,["board_id", "stage_id"]);
        //         // }

        //         // echo "<pre>";
        //         // print_r($board_detail->tasks);
        //         // exit;

        //         // // Tasks
        //         // $tasks = [];
        //         // $task_timers = [];

        //         // foreach($board_detail->tasks as $task)
        //         // {
        //         //     if(empty($last_imported_time) || (strtotime($task->updated_at) > strtotime($last_imported_time->time)))
        //         //     {
        //         //         $single_task = [];
        //         //         $single_task['board_id'] = $b_inserted->id;
        //         //         $single_task['task_id'] = $task->id;
        //         //         $single_task['kb_board_id'] = $task->board_id;
        //         //         $single_task['kb_workflow_stage_id'] = $task->workflow_stage_id;
        //         //         $single_task['name'] = $task->name;
        //         //         $single_task['description'] = $task->description;
        //         //         $single_task['kb_swimlane_id'] = $task->swimlane_id;
        //         //         $single_task['kb_created_at'] = date("Y-m-d H:i:s", strtotime($task->created_at));
        //         //         $single_task['kb_updated_at'] = date("Y-m-d H:i:s", strtotime($task->updated_at));
        //         //         $single_task['kb_created_by_id'] = $task->created_by_id;
        //         //         $single_task['time_estimate'] = $task->time_estimate;
        //         //         $single_task['assigned_user_id'] = $task->assigned_user_id;
        //         // if($invoice_field != "")
        //         // {
        //         //     $single_task['invoice'] = ($task->$invoice_field != "" && is_numeric($task->$invoice_field)) ? $task->$invoice_field : 0;
        //         // }

        //         //         array_push($tasks, $single_task);

        //         //         // if($task->timers_listed_count > 0)
        //         //         // {
        //         //         //    $response_task_details = Http::timeout(300)->withHeaders([
        //         //         //     'Authorization' => 'Bearer '.$ka->token
        //         //         //     ])->get('https://'.$ka->url.'/api/v3/tasks/'.$task->id.'.json');
                
        //         //         //     $result_task = $response_task_details->getBody()->getContents();

        //         //         //     $task_detail = json_decode($result_task);

        //         //         //     foreach($task_detail->time_trackers as $tt)
        //         //         //     {
        //         //         //         $single_time = [];
        //         //         //         $single_time['user_id']=$tt->user_id;
        //         //         //         $single_time['board_id']=$tt->board_id;
        //         //         //         $single_time['task_id']=$tt->task_id;
        //         //         //         $single_time['listed']=$tt->listed;
        //         //         //         $single_time['started_at']= ($tt->started_at != "") ? date('Y-m-d H:i:s', strtotime($tt->started_at)) : NULL;
        //         //         //         $single_time['ended_at']= ($tt->ended_at != "") ? date('Y-m-d H:i:s', strtotime($tt->ended_at)) : NULL;

        //         //         //         array_push($task_timers, $single_time);
        //         //         //     }
        //         //         // }
        //         //     }
        //         // }

        //         // if(count($tasks) > 0)
        //         // {
        //         //     BoardTasks::upsert($tasks,["board_id", "task_id"]);
        //         // }
        //         // if(count($task_timers)>0)
        //         // {
        //         //     TaskTimers::where('board_id',$board->id)->delete();

        //         //     $chunked_tt = array_chunk($task_timers, 100);
        //         //     foreach($chunked_tt as $tt_insert)
        //         //     {
        //         //         TaskTimers::insert($tt_insert);
        //         //     }
        //         // }
        //     }
        // }

        // // if(empty($last_imported_time))
        // // {
        // //     $insert['time'] = date('Y-m-d H:i:s',time());
        // //     LastImportedTiming::create($insert);
        // // }
        // // else
        // // {
        // //     $last_imported_time->time = date('Y-m-d H:i:s',time());
        // //     $last_imported_time->save();
        // // }

        // echo "s";exit;
    	
        $user = Auth::user();

        $role_id = \Auth::user()->role->id;
            
        if($role_id == 1)
        {
            $levels = GlobalSSMappingLevels::whereIn("id", GlobalSSMappings::pluck("level_id"))->get();

            $levels_workload = WorkloadMappingLevels::whereIn("id", WorkloadMappings::pluck("level_id"))->get();

            $levels_exception = ExceptionMappingLevels::whereIn("id", ExceptionMappings::pluck("level_id"))->get();
        }
        else
        {
            $level_ids = RoleLevels::where('role_id', $role_id)->where('type', 'global')->pluck('level_id');
            $levels = GlobalSSMappingLevels::whereIn("id", GlobalSSMappings::pluck("level_id"))->whereIn("id", $level_ids)->get();

            $level_ids_workload = RoleLevels::where('role_id', $role_id)->where('type', 'workload')->pluck('level_id');

            $levels_workload = WorkloadMappingLevels::whereIn("id", WorkloadMappings::pluck("level_id"))->whereIn("id", $level_ids_workload)->get();

            $level_ids_exception = RoleLevels::where('role_id', $role_id)->where('type', 'exception')->pluck('level_id');

            $levels_exception = ExceptionMappingLevels::whereIn("id", ExceptionMappings::pluck("level_id"))->whereIn("id", $level_ids_exception)->get();
        }

        $boards = Boards::get();

        return view('dashboard.index',compact('user', 'levels', 'levels_workload', 'levels_exception', 'boards'));
    }

    public function get_global_data(Request $request)
    {
        $boards = Boards::get();

        $data = [];

        $mappings = GlobalSSMappings::where("level_id", $request->level_select)->orderBy('label')->get();

        $controller = new GlobalSnapshotController();

        $data = $controller->process_data_dashboard($boards, $mappings, $data, $request);

        return Datatables::of($data)
                    ->make(true);
    }

    public function get_workload_data(Request $request)
    {
        $boards = Boards::get();

        $data = [];

        $mappings = WorkloadMappings::where("level_id", $request->level_select)->get();

        $controller = new WorkloadController();

        $data = $controller->process_data_dashboard($boards, $mappings, $data, $request);

        return Datatables::of($data)
                    ->make(true);
    }

    public function get_exception_data_d(Request $request)
    {
        $data = [];

        if($request->board && $request->board != "")
        {
            $board = Boards::find($request->board);
            $mappings = ExceptionMappings::with(['exception_relations' => function($q) use($board) {
                $q->where("board_id", $board->id);
            }])->where("level_id", $request->level_select)->get();

            $controller = new ExceptionController();

            $data = $controller->process_data_dashabord($board, $mappings, $data, $request);
        }
        
        return Datatables::of($data)
                    ->make(true);
    }
}