<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Boards;
use App\Models\WorkloadMappings;
use App\Models\DailyWorkloadSnapshot;
use App\Models\WorkloadMappingLevels;

use App\Http\Controllers\WorkloadController;

use Carbon\Carbon;

class SnapshotWorkload extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'snapshot:workload';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Workload Snapshot daily backup.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $data = [];
        $data['mapped']=[];
        $data['notmapped']=[];

        $boards = Boards::orderBy('order')->get();
        $levels = WorkloadMappingLevels::get();

        $mappings = WorkloadMappings::whereNull("level_id")->get();
        
        if(count($mappings) > 0)
        {
            $controller = new WorkloadController();

            $records = $controller->process_data($boards, $mappings, $data);

            $data_insert = [];
            
            $date = Carbon::now();
            $today = $date->format('Y-m-d');

            $data_single = [];
            $data_single['date'] = $today;
            $data_single['type'] = 'head';

            $head_arr = [];
            $head_arr[] = "";
            foreach($boards as $b)
            {
                $head_arr[] = $b->name;
            }
            $head_arr[] = "TOTAL";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            foreach($records['mapped'] as $data_mapped)
            {
                $data_single = [];
                $data_single['date'] = $today;
                $data_single['type'] = 'body';

                $data_single['data'] = json_encode($data_mapped);

                array_push($data_insert,$data_single);
            }

            $data_single = [];
            $data_single['date'] = $today;
            $data_single['type'] = 'vertical_t';

            $head_arr = [];
            $head_arr[] = "<b>TOTAL</b>";
            foreach($records['vertical_total'] as $vt)
            {
                $head_arr[] = json_encode($vt);
            }
            $last_td["task_total"] = array_sum(array_column($records['vertical_total'],'task_total'));
            $last_td["time_total"] = array_sum(array_column($records['vertical_total'],'time_total'));
            $last_td["logged_time_total"] = array_sum(array_column($records['vertical_total'],'logged_time_total'));
            $head_arr[] = json_encode($last_td);
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            DailyWorkloadSnapshot::upsert($data_insert, 'id');

        }

        foreach($levels as $l)
        {
            $mappings = WorkloadMappings::where("level_id", $l->id)->get();

            $controller = new WorkloadController();

            $records = $controller->process_data($boards, $mappings, $data);

            $data_insert = [];
            
            $date = Carbon::now();
            $today = $date->format('Y-m-d');

            $data_single = [];
            $data_single['level_id'] = $l->id;
            $data_single['level_label'] = $l->label;
            $data_single['date'] = $today;
            $data_single['type'] = 'head';

            $head_arr = [];
            $head_arr[] = "";
            foreach($boards as $b)
            {
                $head_arr[] = $b->name;
            }
            $head_arr[] = "TOTAL";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            foreach($records['mapped'] as $data_mapped)
            {
                $data_single = [];
                $data_single['level_id'] = $l->id;
                $data_single['level_label'] = $l->label;
                $data_single['date'] = $today;
                $data_single['type'] = 'body';

                $data_single['data'] = json_encode($data_mapped);

                array_push($data_insert,$data_single);
            }

            $data_single = [];
            $data_single['level_id'] = $l->id;
            $data_single['level_label'] = $l->label;
            $data_single['date'] = $today;
            $data_single['type'] = 'vertical_t';

            $head_arr = [];
            $head_arr[] = "<b>TOTAL</b>";
            foreach($records['vertical_total'] as $vt)
            {
                $head_arr[] = json_encode($vt);
            }
            $last_td["task_total"] = array_sum(array_column($records['vertical_total'],'task_total'));
            $last_td["time_total"] = array_sum(array_column($records['vertical_total'],'time_total'));
            $last_td["logged_time_total"] = array_sum(array_column($records['vertical_total'],'logged_time_total'));
            $head_arr[] = json_encode($last_td);
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            DailyWorkloadSnapshot::upsert($data_insert, 'id');

        }

        
    }
}
